# Day 17: Data Structures

## Tasks/Activities:

### Activity 1: Linked List
- **Task 1:** Implement a `Node` class to represent an element in a linked list with properties `value` and `next`.
- **Task 2:** Implement a `LinkedList` class with methods to add a node to the end, remove a node from the end, and display all nodes.

### Activity 2: Stack
- **Task 3:** Implement a `Stack` class with methods `push` (add element), `pop` (remove element), and `peek` (view the top element).
- **Task 4:** Use the `Stack` class to reverse a string by pushing all characters onto the stack and then popping them off.

### Activity 3: Queue
- **Task 5:** Implement a `Queue` class with methods `enqueue` (add element), `dequeue` (remove element), and `front` (view the first element).
- **Task 6:** Use the `Queue` class to simulate a simple printer queue where print jobs are added to the queue and processed in order.

### Activity 4: Binary Tree
- **Task 7:** Implement a `TreeNode` class to represent a node in a binary tree with properties `value`, `left`, and `right`.
- **Task 8:** Implement a `BinaryTree` class with methods for inserting values and performing in-order traversal to display nodes.

### Activity 5: Graph (Optional)
- **Task 9:** Implement a `Graph` class with methods to add vertices, add edges, and perform a breadth-first search (BFS).
- **Task 10:** Use the `Graph` class to represent a simple network and perform BFS to find the shortest path between two nodes.

## Feature Request:
1. **Linked List Script:** Write a script that implements a linked list with methods to add, remove, and display nodes.
2. **Stack Script:** Create a script that implements a stack and uses it to reverse a string.
3. **Queue Script:** Write a script that implements a queue and simulates a printer queue.
4. **Binary Tree Script:** Create a script that implements a binary tree with insertion and in-order traversal methods.
5. **Graph Script:** Write a script that implements a graph and performs breadth-first search (optional).

## Achievement:
By the end of these activities, students will:
- Implement and use linked lists for dynamic data storage.
- Use stacks for LIFO (Last-In-First-Out) operations and reverse data.
- Use queues for FIFO (First-In-First-Out) operations and simulate real-world scenarios.
- Implement binary trees for hierarchical data storage and traversal.
- Understand and use graphs for network representations and pathfinding (optional).
